using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

namespace WindowsGame1
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;
        Sprite tlo;
        public static int szerokosc = 800;
        public static int wysokosc = 600;
        Sprite pilka;

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";

            graphics.PreferredBackBufferWidth = szerokosc;
            graphics.PreferredBackBufferHeight = wysokosc;
            this.Window.Title = "Pong";
            this.IsMouseVisible = true;
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {

            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            spriteBatch = new SpriteBatch(GraphicsDevice);

            tlo = new Sprite(Content.Load<Texture2D>("Pong"), new Vector2(0f, 0f), new Vector2(szerokosc, wysokosc));
            pilka = new Sprite(Content.Load<Texture2D>("Pilka"), new Vector2(szerokosc / 2, wysokosc / 2), new Vector2(szerokosc * 0.04f, szerokosc * 0.04f), new Vector2(3, 3), new Rectangle(0, 0, szerokosc, wysokosc));
        }


        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            SterowanieKlawiatura(pilka);
            //SterowanieMysza(pilka);
            //SterowanieGamepadem(pilka);
            pilka.ZmienPolozenie((float)(gameTime.ElapsedGameTime.TotalMilliseconds / 10)); 

            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            graphics.GraphicsDevice.Clear(Color.CornflowerBlue);

            spriteBatch.Begin();
            spriteBatch.Draw(tlo.tekstura, tlo.ObszarOgraniczajacy, Color.White);
            spriteBatch.Draw(pilka.tekstura, pilka.ObszarOgraniczajacy, Color.Red);
            spriteBatch.End();

            base.Draw(gameTime);
        }

        private void SterowanieKlawiatura(Sprite s)
        {
            KeyboardState stanKlawiatury = Keyboard.GetState();

            if (stanKlawiatury.IsKeyDown(Keys.Up))
            {
                s.predkosc *= 2;
            }
            if (stanKlawiatury.IsKeyDown(Keys.Down))
            {
                if (s.predkosc.X - Math.Sign(s.predkosc.X) != 0)
                    s.predkosc.X /= 2;
                if (s.predkosc.Y - Math.Sign(s.predkosc.Y) != 0)
                    s.predkosc.Y /= 2;
            }
        }

        private void SterowanieMysza(Sprite s)
        {
            MouseState stanMyszy = Mouse.GetState();

            int x = stanMyszy.X;
            int y = stanMyszy.Y;

            if (stanMyszy.LeftButton == ButtonState.Pressed)
            {
                if (x + s.rozmiar.X <= graphics.PreferredBackBufferWidth &&
                    y + s.rozmiar.Y <= graphics.PreferredBackBufferHeight
                    && x > 0 && y > 0)
                {
                    s.polozenie.X = stanMyszy.X;
                    s.polozenie.Y = stanMyszy.Y;
                }
            }
        }

        private void SterowanieGamepadem(Sprite s)
        {
            GamePadState stanGamepada = GamePad.GetState(PlayerIndex.One);

            if (stanGamepada.Buttons.Start == ButtonState.Pressed)
            {
                s.polozenie.X = 275;
                s.polozenie.Y = 220;
            }
            s.predkosc = stanGamepada.ThumbSticks.Right * 5;

            if (Math.Abs(stanGamepada.ThumbSticks.Right.X) >= 0.5f
               || Math.Abs(stanGamepada.ThumbSticks.Right.Y) >= 0.5f)
            {
                GamePad.SetVibration(PlayerIndex.One, 0.25f, 0.25f);
            }
            else GamePad.SetVibration(PlayerIndex.One, 0f, 0f);
        }
    }
}
